<?php
require_once ('public/lib/print/num_letras.php');
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
    function AutoPrint($dialog = false)
    {
        // Abre el diálogo de impresión o imprime directamente en la impresora predeterminada
        $param = ($dialog ? 'true' : 'false');
        $script = "print($param);";
        $this->IncludeJS($script);
    }

    function AutoPrintToPrinter($server, $printer, $dialog = false)
    {
        // Imprime en una impresora compartida (requiere al menos Acrobat 6)
        $script = "var pp = getPrintParams();";
        $script .= ($dialog)
            ? "pp.interactive = pp.constants.interactionLevel.full;"
            : "pp.interactive = pp.constants.interactionLevel.automatic;";
        $script .= "pp.printerName = '\\\\\\\\" . $server . "\\\\" . $printer . "';";
        $script .= "print(pp);";
        $this->IncludeJS($script);
    }
}

define('EURO', chr(128));
$pdf = new FPDF_CellFiti('P', 'mm', array(80, 200));
$pdf->AddPage();
$pdf->SetMargins(0, 0, 0, 0);

// Verifica que $this->dato tenga los datos
if (!isset($this->dato)) {
    die('No se encontraron datos para imprimir.');
}

// CABECERA
$pdf->SetFont('Helvetica', '', 6);
$pdf->Cell(72, 4, '', 0, 1, 'C');
$pdf->SetFont('Helvetica', '', 13);
$pdf->Cell(72, 4, 'PRE-CUENTA', 0, 1, 'C');
$pdf->Ln(3);
$pdf->SetFont('Helvetica', '', 9);

// Usamos el operador ternario para evitar imprimir null
$pdf->Cell(72, 4, 'FECHA: ' . (!empty($this->dato->fecha_pedido) ? date('d-m-Y h:i A', strtotime($this->dato->fecha_pedido)) : 'Sin fecha'), 0, 1, 'L');
$pdf->Cell(72, 4, 'SALON: ' . (!empty($this->dato->desc_salon) ? utf8_decode($this->dato->desc_salon) : 'Sin salón'), 0, 1, 'L');
$pdf->Cell(72, 4, 'MESA: ' . (!empty($this->dato->nro_mesa) ? utf8_decode($this->dato->nro_mesa) : 'Sin mesa'), 0, 1, 'L');

// COLUMNAS
$pdf->SetFont('Helvetica', 'B', 9);
$pdf->Cell(42, 10, 'PRODUCTO', 0);
$pdf->Cell(5, 10, 'CANT.', 0, 0, 'R');
$pdf->Cell(10, 10, 'P.U.', 0, 0, 'R');
$pdf->Cell(15, 10, 'IMP.', 0, 0, 'R');
$pdf->Ln(8);
$pdf->Cell(72, 0, '', 'T');
$pdf->Ln(1);

// PRODUCTOS
$total = 0;
if (!empty($this->dato->Detalle) && is_array($this->dato->Detalle)) {
    foreach ($this->dato->Detalle as $d) {
        $pdf->SetFont('Helvetica', '', 9);
        // Se muestra la presentación o el nombre del producto
        $pdf->MultiCell(42, 4, utf8_decode($d->Producto->pro_pre), 0, 'L');
        $pdf->Cell(47, -4, $d->cantidad, 0, 0, 'R');
        $pdf->Cell(10, -4, $d->precio, 0, 0, 'R');
        $pdf->Cell(15, -4, number_format(($d->cantidad * $d->precio), 2), 0, 0, 'R');
        $pdf->Ln(1);
        $total += ($d->cantidad * $d->precio);
    }
} else {
    $pdf->Cell(72, 4, 'No hay productos agregados.', 0, 1, 'L');
}

$pdf->SetFont('Helvetica', 'B', 10);
$pdf->Cell(72, 0, '', 'T');
$pdf->Ln(1);
$pdf->Cell(37, 10, 'TOTAL', 0);
$pdf->Cell(20, 10, '', 0);
$pdf->Cell(15, 10, number_format($total, 2), 0, 0, 'R');

// PIE DE PAGINA
$pdf->Ln(10);
$pdf->Output('ticket.pdf', 'I');
?>
